#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex15-More on aesthetic mapping in ggplot
#R version 3.6.1
#RStudio version 1.2.5019
rm(list=ls())

library(MASS)
newsurvey <- na.omit(survey)

#Install the dplyr package if it is not installed before 
install.packages('dplyr')

#Import the dplyr package
library(dplyr)

#Install the ggplot2 package if it is not installed before
install.packages('ggplot2')

#Import the ggplot2 package
library(ggplot2)


#1.  Plot the distribution of writing hand span vs. pulse rate of left handers. Provide colour based on gender and vary the size of the point based on height of the student.
newsurvey%>%
  filter(W.Hnd=="Left")%>%
  ggplot(aes(x=Wr.Hnd,y=Pulse,col=Sex,size=Height))+geom_point(alpha=0.5)+ggtitle("Distribution of writing hand span vs. Pulse rate of left handers")+labs(x="Writing hand span",y="Pulse rate")

#2.  Plot the distribution of height of the students with filled colour based on gender with facet based on left and write handers.
ggplot(newsurvey,aes(x=Height,fill=Sex))+geom_histogram()+facet_wrap(~W.Hnd)+ggtitle("Distribution of Height of the students")

#3.  Plot the trend of span of writing hand vs. non-writing hand coloured and grouped based on left and right handers with facet label based on clap.
ggplot(newsurvey,aes(x=Wr.Hnd,y=NW.Hnd,col=W.Hnd,group=W.Hnd))+geom_line()+facet_wrap(~Clap,scale="free")+ggtitle("Trend of Writing hand span Vs. Non-writing hand span of left and right handers based on clap hand")+labs(x="Writing hand span",y="Non-writing hand span")

#4.  Plot the distribution of age of students based on categories under exercise with facet wrap based on gender.
ggplot(newsurvey,aes(x=Age,fill=Exer,group=Exer))+geom_histogram()+facet_wrap(~Sex)+ggtitle("Age distribution of male and female students based on Exercise")

#5.  Plot the box plot of writing hand span with respect to smoking habits of students.
ggplot(newsurvey, aes(x=Smoke,y=Wr.Hnd))+geom_boxplot()+ggtitle("Box plot of Writing hand span based on smoking habits of students")+labs(x="Smoking habits",y="Writing hand span")

